/*
 * Decompiled with CFR 0.152.
 */
package knightminer.simplytea.item;

import java.util.List;
import javax.annotation.Nullable;
import knightminer.simplytea.core.config.TeaDrink;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.Food;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.UseAction;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.text.Color;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class TeaCupItem
extends Item {
    public static final String HONEY_TAG = "with_honey";
    private static final ITextComponent WITH_HONEY = new TranslationTextComponent("item.simplytea.cup.with_honey").func_240700_a_(style -> style.func_240718_a_(Color.func_240743_a_((int)16748822)));

    public TeaCupItem(Item.Properties props) {
        super(props);
    }

    public UseAction func_77661_b(ItemStack stack) {
        return stack.func_77973_b().func_219971_r() ? UseAction.DRINK : UseAction.NONE;
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return stack.func_77952_i() > 0;
    }

    public ItemStack getContainerItem(ItemStack stack) {
        if (stack.func_77952_i() + 1 >= stack.func_77958_k()) {
            return super.getContainerItem(stack);
        }
        stack = stack.func_77946_l();
        stack.func_196085_b(stack.func_77952_i() + 1);
        return stack;
    }

    public ItemStack func_77654_b(ItemStack stack, World worldIn, LivingEntity living) {
        if (this.func_219971_r()) {
            EffectInstance effectInstance;
            ItemStack result = stack.getContainerItem();
            boolean hasHoney = TeaCupItem.hasHoney(stack, HONEY_TAG);
            living.curePotionEffects(stack);
            living.func_213357_a(worldIn, stack);
            Food food = this.func_219967_s();
            if (food instanceof TeaDrink && (effectInstance = ((TeaDrink)food).getEffect(hasHoney)) != null) {
                living.func_195064_c(effectInstance);
            }
            return result;
        }
        return stack;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        if (TeaCupItem.hasHoney(stack, HONEY_TAG)) {
            tooltip.add(WITH_HONEY);
        }
    }

    public static ItemStack withHoney(ItemStack stack, String tag) {
        stack.func_196082_o().func_74757_a(tag, true);
        return stack;
    }

    public static boolean hasHoney(ItemStack stack, String tag) {
        CompoundNBT nbt = stack.func_77978_p();
        return nbt != null && nbt.func_74767_n(tag);
    }
}

